// By EVOLVED
// www.evolved-software.com

//--------------
// Textures
//--------------
   texture TerrainTexture <string Name = "";>;
   sampler TerrainSampler=sampler_state
      {
 	Texture=<TerrainTexture>;
 	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
        ADDRESSw=Clamp;
      };
   texture TerrainTileTexture <string Name = "";>;
   sampler TerrainTileSampler=sampler_state
      {
 	Texture=<TerrainTileTexture>;
 	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
        ADDRESSw=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex:TEXCOORD0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;
 	OUT.Tex=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
	return OUT;
     }

//--------------
// pixel shader
//--------------
  float4 PS(OutPut IN) : COLOR
     {
 	float4 Terrain=tex2D(TerrainSampler,IN.Tex);
 	float2 TerrainTile=tex2D(TerrainTileSampler,IN.Tex).xy;
	return float4(1.0+(TerrainTile.x*255)+(0.001+TerrainTile.y*0.999),Terrain.xy*2.0-1.0,((Terrain.z*255.0)+Terrain.w)-127);
     }

//--------------
// techniques
//--------------
   technique Texture
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
   technique TextureHeight
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
        ColorWriteEnable=14;
      }
      }
   technique TextureLayer
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
        ColorWriteEnable=1;
      }
      }

